//------------------------------------------------------------------
//
//   first version of this indicator by SwingMan
//

#property copyright " 2009.07.06, SwingMan"
#property copyright "www.forex-tsd.com"
#property link      "www.forex-tsd.com"
//------------------------------------------------------------------
#property indicator_separate_window
#property indicator_buffers 6
#property indicator_color1 Gray
#property indicator_color2 LimeGreen
#property indicator_color3 PaleVioletRed
#property indicator_color4 LimeGreen
#property indicator_color5 PaleVioletRed
#property indicator_color6 DarkGray
#property indicator_width2 3
#property indicator_width3 3
#property indicator_width4 3
#property indicator_width5 3
#property indicator_width6 2

//
//
//
//
//

extern string TimeFrame  = "Current time frame";
extern int    HMAPeriod  = 27;
extern int    HMAPrice   = PRICE_CLOSE;
extern double HMADivisor = 1.5;
extern double Treshold   = 10;
extern bool   alertsOn        = false;
extern bool   alertsOnCurrent = false;
extern bool   alertsMessage   = true;
extern bool   alertsSound     = true;
extern bool   alertsEmail     = false;

//
//
//
//
//

double hma[];
double TrendUP[];
double TrendDN[];
double HistoUP[];
double HistoDN[];
double HistoNN[];

string indicatorFileName;
bool   returnBars;
bool   calculateValue;
int    timeFrame;

//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//
//

int init()
{
   IndicatorBuffers(6);
   SetIndexBuffer(0,HistoNN); SetIndexLabel(0,"trend");      SetIndexStyle(0,DRAW_HISTOGRAM);
   SetIndexBuffer(1,HistoUP); SetIndexLabel(1,"retrace UP"); SetIndexStyle(1,DRAW_HISTOGRAM);
   SetIndexBuffer(2,HistoDN); SetIndexLabel(2,"retrace DN"); SetIndexStyle(2,DRAW_HISTOGRAM);   
   SetIndexBuffer(3,TrendUP); SetIndexLabel(3,"sig UP");     SetIndexStyle(3,DRAW_ARROW); SetIndexArrow(3,167);
   SetIndexBuffer(4,TrendDN); SetIndexLabel(4,"sig DN");     SetIndexStyle(4,DRAW_ARROW); SetIndexArrow(4,167);
   SetIndexBuffer(5,hma);

      //
      //
      //
      //
      //
      
         indicatorFileName = WindowExpertName();
         calculateValue    = TimeFrame=="calculateValue"; if (calculateValue) { return(0); }
         returnBars        = TimeFrame=="returnBars";     if (returnBars)     { return(0); }
         timeFrame         = stringToTimeFrame(TimeFrame);
      
      //
      //
      //
      //
      //
               
   IndicatorShortName(timeFrameToString(timeFrame)+" Hull variation slope ("+HMAPeriod+")");
   return(0);
}
int deinit()
{
   return(0);
}

//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//
//

double work[][3];
#define _hma 0
#define _hmo 1
#define _hms 2

int start()
{
   int i,r,counted_bars=IndicatorCounted();
      if(counted_bars<0) return(-1);
      if(counted_bars>0) counted_bars--;
           int limit=MathMin(Bars-counted_bars,Bars-1);
           if (returnBars) { HistoNN[0] = MathMin(limit+1,Bars-1); return(0); }
      
      //
      //
      //
      //
      //
      
   if (calculateValue || timeFrame == Period())
   {
      if (ArrayRange(work,0)!=Bars) ArrayResize(work,Bars);
      for(i=limit,r=Bars-i-1; i>=0; i--,r++)
      {
         work[r][_hma] = iHull(iMA(NULL,0,1,0,MODE_SMA,HMAPrice,i),HMAPeriod,HMADivisor,i,0); if (r<1) continue;
         work[r][_hmo] = 100.0*(work[r][_hma]-work[r-1][_hma])/work[r-1][_hma];
         work[r][_hms] = (4.0*work[r][_hmo]+3.0*work[r-1][_hmo]+2.0*work[r-2][_hmo]+work[r-3][_hmo])/10.0;
                hma[i] = work[r][_hmo];
                
         //
         //
         //
         //
         //
                  
         double minVal = MathMin(work[r][_hmo],work[r][_hms]);
         double maxVal = MathMax(work[r][_hmo],work[r][_hms]);
         double diffP  = 0; if (minVal != 0) diffP = MathAbs(100 * (maxVal-minVal)/minVal);

         HistoUP[i] = EMPTY_VALUE;
         HistoDN[i] = EMPTY_VALUE;
         HistoNN[i] = EMPTY_VALUE;
         TrendUP[i] = TrendUP[i+1];
         TrendDN[i] = TrendDN[i+1];
            if (work[r][_hmo] > work[r][_hms] && diffP > Treshold) { TrendUP[i] = 0; TrendDN[i] = EMPTY_VALUE; }
            if (work[r][_hmo] < work[r][_hms] && diffP > Treshold) { TrendDN[i] = 0; TrendUP[i] = EMPTY_VALUE; }
            if (work[r][_hmo] > 0 && TrendUP[i]== 0) if(High[i] <= High[i+1]) HistoUP[i] = work[r][_hmo]; else HistoNN[i]= work[r][_hmo];
            if (work[r][_hmo] < 0 && TrendDN[i]== 0) if(Low[i]  >= Low[i+1])  HistoDN[i] = work[r][_hmo]; else HistoNN[i]= work[r][_hmo];
      }
      manageAlerts();
      return(0);
   }
   
   //
   //
   //
   //
   //
   
   limit = MathMax(limit,MathMin(Bars-1,iCustom(NULL,timeFrame,indicatorFileName,"returnBars",0,0)*timeFrame/Period()));
   for (i=limit; i>=0; i--)
   {
      int y = iBarShift(NULL,timeFrame,Time[i]);
         HistoNN[i] = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",HMAPeriod,HMAPrice,HMADivisor,Treshold,alertsOn,alertsOnCurrent,alertsMessage,alertsSound,alertsEmail,0,y);
         HistoUP[i] = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",HMAPeriod,HMAPrice,HMADivisor,Treshold,alertsOn,alertsOnCurrent,alertsMessage,alertsSound,alertsEmail,1,y);
         HistoDN[i] = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",HMAPeriod,HMAPrice,HMADivisor,Treshold,alertsOn,alertsOnCurrent,alertsMessage,alertsSound,alertsEmail,2,y);
         TrendUP[i] = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",HMAPeriod,HMAPrice,HMADivisor,Treshold,alertsOn,alertsOnCurrent,alertsMessage,alertsSound,alertsEmail,3,y);
         TrendDN[i] = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",HMAPeriod,HMAPrice,HMADivisor,Treshold,alertsOn,alertsOnCurrent,alertsMessage,alertsSound,alertsEmail,4,y);
         hma[i]     = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",HMAPeriod,HMAPrice,HMADivisor,Treshold,alertsOn,alertsOnCurrent,alertsMessage,alertsSound,alertsEmail,5,y);
   }   
   return(0);
         
}


//-------------------------------------------------------------------
//                                                                  
//-------------------------------------------------------------------
//
//
//
//
//

void manageAlerts()
{
   if (alertsOn)
   {
      if (alertsOnCurrent)
           int whichBar = 0;
      else     whichBar = 1;
      if (TrendUP[whichBar] == 0 && TrendUP[whichBar+1]==EMPTY_VALUE) doAlert(whichBar,"up");
      if (TrendDN[whichBar] == 0 && TrendDN[whichBar+1]==EMPTY_VALUE) doAlert(whichBar,"down");
   }
}

//
//
//
//
//

void doAlert(int forBar, string doWhat)
{
   static string   previousAlert="nothing";
   static datetime previousTime;
   string message;
   
   if (previousAlert != doWhat || previousTime != Time[forBar]) {
       previousAlert  = doWhat;
       previousTime   = Time[forBar];

       //
       //
       //
       //
       //

       message =  timeFrameToString(Period())+" "+Symbol()+" at "+TimeToStr(TimeLocal(),TIME_SECONDS)+" hull slope oscillator changed to "+doWhat;
          if (alertsMessage) Alert(message);
          if (alertsEmail)   SendMail(Symbol()+" hull slope oscillator",message);
          if (alertsSound)   PlaySound("alert2.wav");
   }
}

//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//
//

double workHull[][4];
double iHull(double price, double period, double divisor, int r, int instanceNo=0)
{
   if (ArrayRange(workHull,0)!= Bars) ArrayResize(workHull,Bars); r=Bars-r-1;

   //
   //
   //
   //
   //

      int HmaPeriod  = MathMax(period,2);
      int HalfPeriod = MathFloor(HmaPeriod/divisor);
      int HullPeriod = MathFloor(MathSqrt(HmaPeriod));
      double hma,hmw,weight; instanceNo *= 2;

         workHull[r][instanceNo] = price;

         //
         //
         //
         //
         //
               
         hmw = HalfPeriod; hma = hmw*price; 
            for(int k=1; k<HalfPeriod && (r-k)>=0; k++)
            {
               weight = HalfPeriod-k;
               hmw   += weight;
               hma   += weight*workHull[r-k][instanceNo];  
            }             
            workHull[r][instanceNo+1] = 2.0*hma/hmw;

         hmw = HmaPeriod; hma = hmw*price; 
            for(k=1; k<period && (r-k)>=0; k++)
            {
               weight = HmaPeriod-k;
               hmw   += weight;
               hma   += weight*workHull[r-k][instanceNo];
            }             
            workHull[r][instanceNo+1] -= hma/hmw;

         //
         //
         //
         //
         //
         
         hmw = HullPeriod; hma = hmw*workHull[r][instanceNo+1];
            for(k=1; k<HullPeriod && (r-k)>=0; k++)
            {
               weight = HullPeriod-k;
               hmw   += weight;
               hma   += weight*workHull[r-k][1+instanceNo];  
            }
   return(hma/hmw);
}



//-------------------------------------------------------------------
//
//-------------------------------------------------------------------
//
//
//
//
//

string sTfTable[] = {"M1","M5","M15","M30","H1","H4","D1","W1","MN"};
int    iTfTable[] = {1,5,15,30,60,240,1440,10080,43200};

//
//
//
//
//

int stringToTimeFrame(string tfs)
{
   tfs = stringUpperCase(tfs);
   for (int i=ArraySize(iTfTable)-1; i>=0; i--)
         if (tfs==sTfTable[i] || tfs==""+iTfTable[i]) return(MathMax(iTfTable[i],Period()));
                                                      return(Period());
}
string timeFrameToString(int tf)
{
   for (int i=ArraySize(iTfTable)-1; i>=0; i--) 
         if (tf==iTfTable[i]) return(sTfTable[i]);
                              return("");
}

//
//
//
//
//

string stringUpperCase(string str)
{
   string   s = str;

   for (int length=StringLen(str)-1; length>=0; length--)
   {
      int char = StringGetChar(s, length);
         if((char > 96 && char < 123) || (char > 223 && char < 256))
                     s = StringSetChar(s, length, char - 32);
         else if(char > -33 && char < 0)
                     s = StringSetChar(s, length, char + 224);
   }
   return(s);
}